﻿-- Created 2019-04-30: 

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBufferRoleWeight]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBufferRoleWeight]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBufferRoleWeight]
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@UseQuotas bit = 0,
	@dncFlag int = 1,
	@isPreviewSupported bit = 1,
	@dncExpirationDate datetime = 0,
	@FilterEmptyPhone bit = 0,
	@PhoneAlias nvarchar(32) = '',
	@ManualFilter int = null, -- (null (default), 0, 1)
	@TotalExtractedCases int OUT
AS
	SET @TotalExtractedCases = 0
	--##############################
	-- weight distribution
	--##############################
	INSERT INTO #BufferNewTemp (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode, Weighted, Ranking, Position )
	SELECT ResRespondent, 0, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode ,max(Weighted) as Weighted, min(Ranking) as Ranking, min(Position) as Position
	FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, 
			case when @PhoneAlias = '' then Resphone else Phone.RpsContent end ResPhone, Res.DialingMode,
			case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
			ceiling((row_number() over (partition by qtquotaid order by (case when Qt.QtWeight <> 0 then 1 else 0 end) desc, Res.RestrictionOverride desc, respriority desc, (case when rescallbackdate < '1901-01-01T00:00:00' then  '9999-12-31T23:59:59' else ResCallbackDate end), Res.ResSeed)) 
				* (case when qtweight <> 0 then 1/qtweight else 1 end)) AS Ranking,
			abs(cast(binary_checksum(newid())as int)) AS Position
		FROM Respondent Res with(nolock)
		left join (select strRespondent, qtquotaid, qtweight 
					from Stratum with(nolock) 
					inner join Quota Qt with(nolock) on strquotaid = qtquotaid
					where qt.qtstatustemp <> 2 and qtweight <> 0)
				Qt on resrespondent = strrespondent
		left join Response Phone with(nolock) on @PhoneAlias <> '' and Res.ResRespondent = Phone.RpsRespondent and Phone.RpsQuestion = @PhoneAlias and Phone.RpsMatrix = 1 and Phone.RpsMention = 1 and Phone.RpsType = 0
		WHERE 
			/*Invariable criterion (should be same for every query in this SP */
			(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
			and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
			and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
			and (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)) --Prevent double insert & remove excluded
			and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE ( @dncFlag = 1 AND resphone=phone ) OR (@dncFlag = 2 AND resphone=phone AND RegistrationDate > @dncExpirationDate ))) --Exclude DNC if active
			and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
			and (@FilterEmptyPhone = 0 or ((@PhoneAlias = '' and Res.Resphone <> '') or (@PhoneAlias <> '' and Phone.RpsContent is not null and Phone.RpsContent <> '')))
			and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
				or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
					(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
					(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
			/*Variable criterion*/
			and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
			and (@ManualFilter is null or Res.ManualDialing = @ManualFilter)
		ORDER BY --Must sort out the cases exceeding their quota for half open and filter(post) them out
			Weighted desc, --Weighted stratum first, but we may run out
			Res.RestrictionOverride desc, Res.ResPriority desc, 
			--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
			Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
			Position --Randomly distributes the items of same rank according to weight
			) Res        
	GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
	ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)
	SET @TotalExtractedCases = @@RowCount

GO